//: ## ![3DaysOfSwift.com Logo](3DaysIcon46.png) Type Methods & Properties
//:
//: Some useful values exist as type properties.
//:
//: A type property is a value stored (or a calculated) on the type itself (not the instance).
//:
//: A property is like a variable except it either exists on a type or the instance of that type.
//:
//: The code below exposes the minimum and maximum value an integer can store in Swift.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


// We used to use Int32 before the use of 64 bit processors
//Int32 has a range from negative -2,147,483,648 through positive +2,147,483,647.
print(Int32.min)
print(Int32.max)

// Now we use 64 bit processors by default
// Int64 has a minimum value of -9,223,372,036,854,775,808 and a maximum value of 9,223,372,036,854,775,807.
print(Int64.min)
print(Int64.max)

let sixtyFourByDefault: Int = 64 // Int is Int64 in Swift


//:
//: -------------------
//:
//: ## Task:
//:
//: In the code area below, print the maximum positive integer the `Int` type can represent.
//:
//: Print the minimum negative integer the `Int` type can represent.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


// write code here


//:
//: -------------------
//:
//: ## Task:
//:
//: In the code area below, print a randomly selected boolean value.
//:
//: Don't forget to explore the type methods on the `Bool` type.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


// write code here


//:
//: -------------------
//:
//: ## Task:
//:
//: Using the code below as reference, print the maximum number the `Double` type can represent.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:



Double.infinity
Double.greatestFiniteMagnitude
Double.leastNonzeroMagnitude
Double.leastNormalMagnitude
Double.zero
Double.nan
Double.pi


//:
//: -------------------
//:
//: ## Task:
//:
//: Let's make the Swift language a little easier to use!
//:
//: Using the code area below, declare a Swift extension for the `Double` type and add two new type properties called `min` and `max`.
//:
//: You'll need to use computed properties and return the `leastNormalMagnitude` and `greatestFiniteMagnitude` type properties.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


// write your extension here








// an example of an extension is below
extension Bool {
    static var getTrue: Bool {
        return true
    }
    static var getFalse: Bool {
        return false
    }
}
let trueOrFalse: Bool = Bool.getFalse





//: -------------------
//:
//: * callout(💡 Tip):
//:     → Keywords in Swift are words that are reserved to construct instructions using the language.
//:
//:     In our `Bool` extension above we wanted to use `true` and `false` for the type property names but the compiler generated an error stating that these keywords cannot be used.
//:
//: -------------------
//:
//: ## Task:
//:
//: Write another `Bool` extension and use `true` and `false` for the type property names.
//:
//: In order to accomplish this you will need to use backticks to surround each reserved keyword `` `true` `` and `` `false` ``.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


extension Bool {
    // write code here
}
//let `false` = Bool.false
//print(`false`)


//:
//: -------------------
//:
//: ## Task:
//:
//: Write an extension of the `String` type and add a new type property (also know as a static property).
//:
//: This type property should return an exclamation mark (`!`).
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


// write code here


//:
//: -------------------
//:
//: ## Task:
//:
//: Using a similar approach to the code above, declare another `String` extension, except this time write an instance property to return a question mark (`?`).
//:
//: Can you think of why the instance property is bad choice for our architecture here?
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


// write code here


//:
//: -------------------
//:
//: Type properties are great for providing values about the type itself.
//:
//: Instance properties are great for providing values for the specific data loaded into memory being represented by the type.
//:
//: -------------------
//:
//: ## Task:
//:
//: In the code area below, write your full name in a `String` variable with a space separating each word.
//:
//: Print the number of characters your name has after each space has been stripped away.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


var name = "Matthew Fleming"
name.removeAll() { element in
    return element == " " ? true : false
}

// write code here


// more cool stuff?
// remove the ? true : false and the code still works
// remove the return keyword and the code still works
// remove the brackets after removeAll and the code still works
// Swift allows us to shorten our code in a lot of ways


//:
//: -------------------
//:
//: * callout(💡 Tip):
//:     → A few functions above contain only 1 line of code.
//:
//:     Go back and remove the `return` keyword from all one-line functions declared above.
//:
//:     Get as much practice as you can with these subtle language features. They may impress a colleague in the future.
//:
//: -------------------
//:
